<?php

    /*
     * copyright (c) 2013-2022 Heliac Technologies
     * license http://opensource.org/licenses/gpl-license.php GNU GPL v3 
     *
     * linee guida per l'utilizzo del logo http://www.geecom.org/index.php?alias=linee-guida-per-luso-del-logo-geecom
     * 
     */

    // l'array delle animazioni è usato in tutti i componenti dove devono essere 
    // scelte animazioni (testo, immagine, intestazione ecc)
    $arrayOpzioniSeparatore = array("Nessuno","Sopra","Sotto");
    $arrayOpzioniAllineamento = array(""=>"Sinistra","text-center"=>"Centro","text-right"=>"Destra");
        
    /*
     * serve perché questa popup può essere richiamata dal file creaElemento.php del componente 
     * portfolio e dal file creaProdotto.php, in tal caso bisogna inserire nel percorso "../../"
     */
    if(isset($prodotto)) {
        $percorso     = "../../";
        $tipoElemento = "prodotto";
        $stringaAggiuntivaQuery = "";
    }
    else {
        $percorsoBase  = (isset($contenuto) && ($contenuto->getTipo()=="elementoPortfolio" || $contenuto->getTipo()=="evento")) ? "../../" : "";
        $tipoElemento = (isset($contenuto) && ($contenuto->getTipo()!="articolo" && $contenuto->getTipo()!="pagina" && $contenuto->getTipo()!="galleria")) ? $contenuto->getTipo() : "contenuto";
        $stringaAggiuntivaQuery = ($tipoElemento=="contenuto") ? " OR c.tipoElemento LIKE 'contenutoSezione'" : "";
    }

    $queryComponentiDaMostrare = "SELECT c.id, c.idComponente, cm.nome, cm.tipo, c.posizione, c.testo, c.idSezione, c.classeSezione, c.idElemento, c.animazione, c.altreOpzioni FROM geecB_composizionePagine AS c JOIN geecB_componenti AS cm ON c.idComponente=cm.id 
                                    WHERE idPagina={$contenuto->getId()} AND (c.tipoElemento LIKE '$tipoElemento' $stringaAggiuntivaQuery) ORDER BY c.posizione ASC";
    $risComponenti = $geecomDb->eseguiQueryLettura($queryComponentiDaMostrare);

    while($componente = $risComponenti->fetch_assoc()) {
        if($componente["tipo"]=="componenteDinamico") {

            ?>
            <div class="modal fade" id="configuraComponente<?php echo $componente["id"]; ?>" tabindex="-1" role="dialog" aria-labelledby="modifica componente intestazione" aria-hidden="true">
                <div class="modal-dialog modal-lg" role="document">
                    <div class="modal-content">
                        <div class="modal-header">
                            <h5 class="modal-title">Componente <?php echo $componente["nome"] ?></h5>
                            <button type="button" class="close" data-dismiss="modal" aria-label="Chiudi">
                            <span aria-hidden="true">&times;</span>
                            </button>
                        </div>
                        <div class="modal-body">
                            <form name="formAggiornaComponente<?php echo $componente["id"]; ?>" action="<?php echo $percorsoBase ?>../controller/<?php echo((isset($prodotto)) ? "ecommerce/controllerProdotti.php" : "controllerContenuti.php") ?>" method="post" enctype="multipart/form-data" >
                                <input type="text" class="d-none" name="id" value="<?php echo $componente["id"] ?>">
                                <input type="text" class="d-none" name="idComponente" value="<?php echo $componente["idComponente"] ?>">
                                <input type="text" class="d-none" name="operazione" value="modificaComponente">
                                <?php 
                                    if($componente["nome"]=="Html") {
                                        echo"<textarea class=\"form-control\" name=\"testo\" rows=\"15\">{$componente["testo"]}</textarea>";
                                    }
                                    else if($componente["nome"]=="Testo") {
                                        // codice valido solo fino a quando il c'è un campo
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                        include"{$percorsoBase}include/campiComponenteDinamico.php";
                                ?>

                                <textarea class="tiny"  name="testo" rows="10"><?php echo $componente["testo"] ?></textarea>
                                <?php
                                    }
                                    else if($componente["nome"]=="Intestazione") {
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                        include"{$percorsoBase}include/campiComponenteDinamico.php";
                                ?>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputPassword3">Tipo etichetta</label>
                                        <select class="form-control" name="opzioneTagH">
                                        <?php 
                                            $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
                                            $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                            $arrayOpzioniH = array("h1","h2","h3","h4","h5","h6");
                                            foreach($arrayOpzioniH as $elemento) {
                                                if($intestazioneScelta==$elemento) {
                                                    echo"<option value=\"$elemento\" selected>$elemento</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$elemento\">$elemento</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputPassword3" >Allineamento</label>
                                        <select class="form-control" name="opzioneAllineamento">
                                        <?php 
                                            // codice valido solo fino a quando il c'è un campo
                                            $arrayOpzioneAllineamento = explode("=",$arrayOpzioni[3]);
                                            $opzioneAllineamento = str_replace(";","",$arrayOpzioneAllineamento[1]);
                                            foreach($arrayOpzioniAllineamento as $classe=>$descrizione) {
                                                if($opzioneAllineamento==$classe) {
                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                    </div>
                                    <div class="form-group col-md-6">
                                        <label for="inputPassword3" >Separatore</label>
                                        <select class="form-control" name="opzioneSeparatore">
                                        <?php 
                                            // codice valido solo fino a quando il c'è un campo
                                            $arrayOpzioneSceltaSeparatore = explode("=",$arrayOpzioni[2]);
                                            $opzioneSeparatore = str_replace(";","",$arrayOpzioneSceltaSeparatore[1]);
                                            foreach($arrayOpzioniSeparatore as $opzione) {
                                                if($opzioneSeparatore==$opzione) {
                                                    echo"<option value=\"$opzione\" selected>$opzione</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$opzione\">$opzione</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                    </div>
                                </div>

                                <div class="form-group">
                                    <label for="inputPassword3" >Titolo</label>
                                    <input type="text" class="form-control" name="testo" value="<?php echo $componente["testo"] ?>">
                                </div>
                                <?php
                                    }
                                    else if($componente["nome"]=="Profili social") {
                                        // codice valido solo fino a quando il c'è un campo
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                        include"{$percorsoBase}include/campiComponenteDinamico.php";
                                ?>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputPassword3">Dimensioni icona</label>
                                        <select class="form-control" name="opzioneDimensioniIcona">
                                        <?php 
                                            $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
                                            $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                            $arrayOpzioniDimensione = array("fa-2x"=>"2x","fa-3x"=>"3x","fa-5x"=>"5x","fa-7x"=>"7x","fa-10x"=>"10x");
                                            foreach($arrayOpzioniDimensione as $classe=>$opzione) {
                                                if($intestazioneScelta==$classe) {
                                                    echo"<option value=\"$classe\" selected>$opzione</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$classe\">$opzione</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                    </div>
                                </div>
                                <?php
                                    }
                                    else if($componente["nome"]=="Separatore") {
                                        // codice valido solo fino a quando il c'è un campo
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                ?>
                                <div class="form-row">
                                    <div class="form-group col-md-6">
                                        <label for="inputPassword3" >Spazio occupato</label>
                                        <select class="form-control" name="opzioneClasseColonne">
                                        <?php 
                                            $arrayOpzioneSpazioOccupato = explode("=",$arrayOpzioni[0]);
                                            $spazioOccupato = str_replace(";","",$arrayOpzioneSpazioOccupato[1]);
                                            foreach($arrayDimensioniColonna as $classe=>$descrizione) {
                                                if($spazioOccupato==$classe) {
                                                    echo"<option value=\"$classe\" selected>$descrizione</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$classe\">$descrizione</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                    </div>
                                    
                                    <div class="form-group col-md-6">
                                        <label for="inputPassword3">Stile</label>
                                        <select class="form-control" name="opzioneStile">
                                        <?php 
                                            $arrayIntestazioneScelta = explode("=",$arrayOpzioni[1]);
                                            $intestazioneScelta = str_replace(";","",$arrayIntestazioneScelta[1]);
                                            $arrayStiliSeparatore = array("stile-1","stile-2","zigzag");
                                            foreach($arrayStiliSeparatore as $stile) {
                                                if($intestazioneScelta==$stile) {
                                                    echo"<option value=\"$stile\" selected>$stile</option>";
                                                }
                                                else {
                                                    echo"<option value=\"$stile\">$stile</option>";
                                                }
                                            }
                                        ?>
                                        </select>
                                    </div>
                                </div>
                                <?php
                                    }
                                    else if($componente["nome"]=="Includi codice") {
                                ?>
                                        <div class="form-group">
                                            <label for="inputPassword3" >File php da includere</label>
                                            <input type="text" class="form-control" name="testo" value="<?= $componente["testo"] ?>">
                                            <small>Il file deve essere caricato in <strong>template/include/fileInclusione</strong></small>
                                        </div>
                                <?php
                                    }
                                    else if($componente["nome"]=="Immagine") {
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                        include"{$percorsoBase}include/campiComponenteDinamico.php";
                                        
                                        if(isset($arrayOpzioni[1]) && $arrayOpzioni[1]!="") {
                                            $arrayOpzioneTagAlt = explode("=",$arrayOpzioni[1]);
                                            $tagAlt = str_replace(";","",$arrayOpzioneTagAlt[1]);
                                        }
                                        else {
                                            $tagAlt = "";
                                        }
                                ?>        
                                        <input type="text" class="d-none" name="idElemento" value="<?= $componente["idElemento"]; ?>">
                                        
                                        <div class="row">    
                                            <div class="form-group col-md-6">
                                                <label for="inputPassword3" >Testo alternativo</label>
                                                <input type="text" class="form-control" name="tagAlt" value="<?= $tagAlt ?>">
                                                <small>Inserire il tag alt migliora l'indicizzazione della pagina</small>
                                            </div>

                                            <div class="form-group col-md-6">
                                                <label for="inputPassword3">Carica file</label>
                                                <input type="file" class="form-control-file" id="inputFile" name="file" accept="image/*">
                                            </div>
                                        </div>
                                        
                                        <img class="img-fluid w-100 border" src="<?php echo (($componente["testo"]) ? "{$percorsoBase}../{$componente["testo"]}" : "{$percorsoBase}../immagini/altro/segnaposto.png"); ?>" >
                                <?php
                                    }
                                    else if($componente["nome"]=="Audio") {
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                        include"{$percorsoBase}include/campiComponenteDinamico.php";
                                ?>        
                                        <input type="text" class="d-none" name="idElemento" value="<?php echo $componente["idElemento"]; ?>">
                                        <div class="form-group">
                                            <label for="inputPassword3">Carica file</label>
                                            <input type="file" class="form-control-file" id="inputFile" name="file" accept="audio/*" multiple="">
                                            <small>Il file caricato attualmente è <?php echo $componente["testo"]; ?></small>
                                        </div>

                                <?php
                                    }
                                    else if($componente["nome"]=="Singola risorsa") {
                                        $arrayOpzioni = explode(";",$componente["altreOpzioni"]);
                                        include"{$percorsoBase}include/campiComponenteDinamico.php";
                                        
                                        if(isset($arrayOpzioni[1])) {
                                            $arrayOpzioneNomeRisorsa = explode("=",$arrayOpzioni[1]);
                                            $nomeRisorsa = str_replace(";","",$arrayOpzioneNomeRisorsa[1]);
                                        }
                                        else {
                                            $nomeRisorsa = "";
                                        }
                                ?>        
                                        <input type="text" class="d-none" name="idElemento" value="<?php echo $componente["idElemento"]; ?>">
                                        
                                        <div class="form-group">
                                            <label for="inputPassword3" >Nome risorsa</label>
                                            <input type="text" class="form-control" name="nomeRisorsa" value="<?php echo $nomeRisorsa; ?>">
                                            <small>Nome della risorsa</small>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="inputPassword3">Carica file</label>
                                            <input type="file" class="form-control-file" id="inputFile" name="file" multiple="">
                                            <small>Il file caricato attualmente è <?php echo $componente["testo"]; ?></small>
                                        </div>
                                <?php
                                    }
                                ?>
                            </form>
                        </div>
                        <div class="modal-footer">
                            <button type="button" class="btn btn-outline-primary btn-sm" data-dismiss="modal"><i class="fas fa-times"></i> Annulla</button>
                            <button type="button" class="btn btn-primary btn-sm" onclick="document.formAggiornaComponente<?php echo $componente["id"]; ?>.submit()"><i class="fas fa-check"></i> Salva</button>
                        </div>
                    </div>
                </div>
            </div>
            <?php
        }
    }